package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Remediation(
    recommendation: Optional[zio.aws.codegurusecurity.model.Recommendation] =
      Optional.Absent,
    suggestedFixes: Optional[
      Iterable[zio.aws.codegurusecurity.model.SuggestedFix]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.Remediation = {
    import Remediation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.Remediation
      .builder()
      .optionallyWith(recommendation.map(value => value.buildAwsValue()))(
        _.recommendation
      )
      .optionallyWith(
        suggestedFixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suggestedFixes)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.Remediation.ReadOnly =
    zio.aws.codegurusecurity.model.Remediation.wrap(buildAwsValue())
}
object Remediation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.Remediation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.Remediation =
      zio.aws.codegurusecurity.model.Remediation(
        recommendation.map(value => value.asEditable),
        suggestedFixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def recommendation
        : Optional[zio.aws.codegurusecurity.model.Recommendation.ReadOnly]
    def suggestedFixes
        : Optional[List[zio.aws.codegurusecurity.model.SuggestedFix.ReadOnly]]
    def getRecommendation: ZIO[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.Recommendation.ReadOnly
    ] = AwsError.unwrapOptionField("recommendation", recommendation)
    def getSuggestedFixes: ZIO[Any, AwsError, List[
      zio.aws.codegurusecurity.model.SuggestedFix.ReadOnly
    ]] = AwsError.unwrapOptionField("suggestedFixes", suggestedFixes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.Remediation
  ) extends zio.aws.codegurusecurity.model.Remediation.ReadOnly {
    override val recommendation
        : Optional[zio.aws.codegurusecurity.model.Recommendation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendation())
        .map(value => zio.aws.codegurusecurity.model.Recommendation.wrap(value))
    override val suggestedFixes
        : Optional[List[zio.aws.codegurusecurity.model.SuggestedFix.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestedFixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurusecurity.model.SuggestedFix.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.Remediation
  ): zio.aws.codegurusecurity.model.Remediation.ReadOnly = new Wrapper(impl)
}
