package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.ScanName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateUploadUrlRequest(scanName: ScanName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlRequest = {
    import CreateUploadUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlRequest
      .builder()
      .scanName(ScanName.unwrap(scanName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.CreateUploadUrlRequest.ReadOnly =
    zio.aws.codegurusecurity.model.CreateUploadUrlRequest.wrap(buildAwsValue())
}
object CreateUploadUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.CreateUploadUrlRequest =
      zio.aws.codegurusecurity.model.CreateUploadUrlRequest(scanName)
    def scanName: ScanName
    def getScanName: ZIO[Any, Nothing, ScanName] = ZIO.succeed(scanName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlRequest
  ) extends zio.aws.codegurusecurity.model.CreateUploadUrlRequest.ReadOnly {
    override val scanName: ScanName =
      zio.aws.codegurusecurity.model.primitives.ScanName(impl.scanName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlRequest
  ): zio.aws.codegurusecurity.model.CreateUploadUrlRequest.ReadOnly =
    new Wrapper(impl)
}
