package zio.aws.codegurusecurity.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codegurusecurity.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class MetricsSummary(
    categoriesWithMostFindings: Optional[
      Iterable[zio.aws.codegurusecurity.model.CategoryWithFindingNum]
    ] = Optional.Absent,
    date: Optional[Timestamp] = Optional.Absent,
    openFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
    ] = Optional.Absent,
    scansWithMostOpenCriticalFindings: Optional[
      Iterable[zio.aws.codegurusecurity.model.ScanNameWithFindingNum]
    ] = Optional.Absent,
    scansWithMostOpenFindings: Optional[
      Iterable[zio.aws.codegurusecurity.model.ScanNameWithFindingNum]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.MetricsSummary = {
    import MetricsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.MetricsSummary
      .builder()
      .optionallyWith(
        categoriesWithMostFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoriesWithMostFindings)
      .optionallyWith(date.map(value => Timestamp.unwrap(value): Instant))(
        _.date
      )
      .optionallyWith(openFindings.map(value => value.buildAwsValue()))(
        _.openFindings
      )
      .optionallyWith(
        scansWithMostOpenCriticalFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scansWithMostOpenCriticalFindings)
      .optionallyWith(
        scansWithMostOpenFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scansWithMostOpenFindings)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.MetricsSummary.ReadOnly =
    zio.aws.codegurusecurity.model.MetricsSummary.wrap(buildAwsValue())
}
object MetricsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.MetricsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.MetricsSummary =
      zio.aws.codegurusecurity.model.MetricsSummary(
        categoriesWithMostFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        date.map(value => value),
        openFindings.map(value => value.asEditable),
        scansWithMostOpenCriticalFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scansWithMostOpenFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def categoriesWithMostFindings: Optional[
      List[zio.aws.codegurusecurity.model.CategoryWithFindingNum.ReadOnly]
    ]
    def date: Optional[Timestamp]
    def openFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ]
    def scansWithMostOpenCriticalFindings: Optional[
      List[zio.aws.codegurusecurity.model.ScanNameWithFindingNum.ReadOnly]
    ]
    def scansWithMostOpenFindings: Optional[
      List[zio.aws.codegurusecurity.model.ScanNameWithFindingNum.ReadOnly]
    ]
    def getCategoriesWithMostFindings: ZIO[Any, AwsError, List[
      zio.aws.codegurusecurity.model.CategoryWithFindingNum.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "categoriesWithMostFindings",
      categoriesWithMostFindings
    )
    def getDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("date", date)
    def getOpenFindings: ZIO[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = AwsError.unwrapOptionField("openFindings", openFindings)
    def getScansWithMostOpenCriticalFindings: ZIO[Any, AwsError, List[
      zio.aws.codegurusecurity.model.ScanNameWithFindingNum.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "scansWithMostOpenCriticalFindings",
      scansWithMostOpenCriticalFindings
    )
    def getScansWithMostOpenFindings: ZIO[Any, AwsError, List[
      zio.aws.codegurusecurity.model.ScanNameWithFindingNum.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "scansWithMostOpenFindings",
      scansWithMostOpenFindings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.MetricsSummary
  ) extends zio.aws.codegurusecurity.model.MetricsSummary.ReadOnly {
    override val categoriesWithMostFindings: Optional[
      List[zio.aws.codegurusecurity.model.CategoryWithFindingNum.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.categoriesWithMostFindings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurusecurity.model.CategoryWithFindingNum.wrap(item)
        }.toList
      )
    override val date: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.codegurusecurity.model.primitives.Timestamp(value))
    override val openFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openFindings())
      .map(value =>
        zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
          .wrap(value)
      )
    override val scansWithMostOpenCriticalFindings: Optional[
      List[zio.aws.codegurusecurity.model.ScanNameWithFindingNum.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scansWithMostOpenCriticalFindings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurusecurity.model.ScanNameWithFindingNum.wrap(item)
        }.toList
      )
    override val scansWithMostOpenFindings: Optional[
      List[zio.aws.codegurusecurity.model.ScanNameWithFindingNum.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scansWithMostOpenFindings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurusecurity.model.ScanNameWithFindingNum.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.MetricsSummary
  ): zio.aws.codegurusecurity.model.MetricsSummary.ReadOnly = new Wrapper(impl)
}
