package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.ScanName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetFindingsError(
    errorCode: zio.aws.codegurusecurity.model.ErrorCode,
    findingId: String,
    message: String,
    scanName: ScanName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError = {
    import BatchGetFindingsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError
      .builder()
      .errorCode(errorCode.unwrap)
      .findingId(findingId: java.lang.String)
      .message(message: java.lang.String)
      .scanName(ScanName.unwrap(scanName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.BatchGetFindingsError.ReadOnly =
    zio.aws.codegurusecurity.model.BatchGetFindingsError.wrap(buildAwsValue())
}
object BatchGetFindingsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.BatchGetFindingsError =
      zio.aws.codegurusecurity.model.BatchGetFindingsError(
        errorCode,
        findingId,
        message,
        scanName
      )
    def errorCode: zio.aws.codegurusecurity.model.ErrorCode
    def findingId: String
    def message: String
    def scanName: ScanName
    def getErrorCode
        : ZIO[Any, Nothing, zio.aws.codegurusecurity.model.ErrorCode] =
      ZIO.succeed(errorCode)
    def getFindingId: ZIO[Any, Nothing, String] = ZIO.succeed(findingId)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
    def getScanName: ZIO[Any, Nothing, ScanName] = ZIO.succeed(scanName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError
  ) extends zio.aws.codegurusecurity.model.BatchGetFindingsError.ReadOnly {
    override val errorCode: zio.aws.codegurusecurity.model.ErrorCode =
      zio.aws.codegurusecurity.model.ErrorCode.wrap(impl.errorCode())
    override val findingId: String = impl.findingId(): String
    override val message: String = impl.message(): String
    override val scanName: ScanName =
      zio.aws.codegurusecurity.model.primitives.ScanName(impl.scanName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError
  ): zio.aws.codegurusecurity.model.BatchGetFindingsError.ReadOnly =
    new Wrapper(impl)
}
