package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SuggestedFix(
    code: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix = {
    import SuggestedFix.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.SuggestedFix.ReadOnly =
    zio.aws.codegurusecurity.model.SuggestedFix.wrap(buildAwsValue())
}
object SuggestedFix {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.SuggestedFix =
      zio.aws.codegurusecurity.model
        .SuggestedFix(code.map(value => value), description.map(value => value))
    def code: Optional[String]
    def description: Optional[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix
  ) extends zio.aws.codegurusecurity.model.SuggestedFix.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix
  ): zio.aws.codegurusecurity.model.SuggestedFix.ReadOnly = new Wrapper(impl)
}
