package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetMetricsSummaryRequest(date: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryRequest = {
    import GetMetricsSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryRequest
      .builder()
      .date(Timestamp.unwrap(date): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.GetMetricsSummaryRequest.ReadOnly =
    zio.aws.codegurusecurity.model.GetMetricsSummaryRequest
      .wrap(buildAwsValue())
}
object GetMetricsSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.GetMetricsSummaryRequest =
      zio.aws.codegurusecurity.model.GetMetricsSummaryRequest(date)
    def date: Timestamp
    def getDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(date)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryRequest
  ) extends zio.aws.codegurusecurity.model.GetMetricsSummaryRequest.ReadOnly {
    override val date: Timestamp =
      zio.aws.codegurusecurity.model.primitives.Timestamp(impl.date())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryRequest
  ): zio.aws.codegurusecurity.model.GetMetricsSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
