package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFindingsResponse(
    findings: Optional[Iterable[zio.aws.codegurusecurity.model.Finding]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse = {
    import GetFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse
      .builder()
      .optionallyWith(
        findings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.GetFindingsResponse.ReadOnly =
    zio.aws.codegurusecurity.model.GetFindingsResponse.wrap(buildAwsValue())
}
object GetFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.GetFindingsResponse =
      zio.aws.codegurusecurity.model.GetFindingsResponse(
        findings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def findings
        : Optional[List[zio.aws.codegurusecurity.model.Finding.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getFindings: ZIO[Any, AwsError, List[
      zio.aws.codegurusecurity.model.Finding.ReadOnly
    ]] = AwsError.unwrapOptionField("findings", findings)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse
  ) extends zio.aws.codegurusecurity.model.GetFindingsResponse.ReadOnly {
    override val findings
        : Optional[List[zio.aws.codegurusecurity.model.Finding.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurusecurity.model.Finding.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurusecurity.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse
  ): zio.aws.codegurusecurity.model.GetFindingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
