package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FindingMetricsValuePerSeverity(
    critical: Optional[Double] = Optional.Absent,
    high: Optional[Double] = Optional.Absent,
    info: Optional[Double] = Optional.Absent,
    low: Optional[Double] = Optional.Absent,
    medium: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.FindingMetricsValuePerSeverity = {
    import FindingMetricsValuePerSeverity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.FindingMetricsValuePerSeverity
      .builder()
      .optionallyWith(critical.map(value => value: java.lang.Double))(
        _.critical
      )
      .optionallyWith(high.map(value => value: java.lang.Double))(_.high)
      .optionallyWith(info.map(value => value: java.lang.Double))(_.info)
      .optionallyWith(low.map(value => value: java.lang.Double))(_.low)
      .optionallyWith(medium.map(value => value: java.lang.Double))(_.medium)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly =
    zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
      .wrap(buildAwsValue())
}
object FindingMetricsValuePerSeverity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.FindingMetricsValuePerSeverity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity =
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity(
        critical.map(value => value),
        high.map(value => value),
        info.map(value => value),
        low.map(value => value),
        medium.map(value => value)
      )
    def critical: Optional[Double]
    def high: Optional[Double]
    def info: Optional[Double]
    def low: Optional[Double]
    def medium: Optional[Double]
    def getCritical: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("critical", critical)
    def getHigh: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("high", high)
    def getInfo: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("info", info)
    def getLow: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("low", low)
    def getMedium: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("medium", medium)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.FindingMetricsValuePerSeverity
  ) extends zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly {
    override val critical: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.critical())
      .map(value => value: Double)
    override val high: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.high())
      .map(value => value: Double)
    override val info: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.info())
      .map(value => value: Double)
    override val low: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.low())
      .map(value => value: Double)
    override val medium: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.medium())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.FindingMetricsValuePerSeverity
  ): zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly =
    new Wrapper(impl)
}
