package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FindingIdentifier(findingId: String, scanName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier = {
    import FindingIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier
      .builder()
      .findingId(findingId: java.lang.String)
      .scanName(scanName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.FindingIdentifier.ReadOnly =
    zio.aws.codegurusecurity.model.FindingIdentifier.wrap(buildAwsValue())
}
object FindingIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.FindingIdentifier =
      zio.aws.codegurusecurity.model.FindingIdentifier(findingId, scanName)
    def findingId: String
    def scanName: String
    def getFindingId: ZIO[Any, Nothing, String] = ZIO.succeed(findingId)
    def getScanName: ZIO[Any, Nothing, String] = ZIO.succeed(scanName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier
  ) extends zio.aws.codegurusecurity.model.FindingIdentifier.ReadOnly {
    override val findingId: String = impl.findingId(): String
    override val scanName: String = impl.scanName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier
  ): zio.aws.codegurusecurity.model.FindingIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
