package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CategoryWithFindingNum(
    categoryName: Optional[String] = Optional.Absent,
    findingNumber: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum = {
    import CategoryWithFindingNum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum
      .builder()
      .optionallyWith(categoryName.map(value => value: java.lang.String))(
        _.categoryName
      )
      .optionallyWith(findingNumber.map(value => value: java.lang.Integer))(
        _.findingNumber
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.CategoryWithFindingNum.ReadOnly =
    zio.aws.codegurusecurity.model.CategoryWithFindingNum.wrap(buildAwsValue())
}
object CategoryWithFindingNum {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.CategoryWithFindingNum =
      zio.aws.codegurusecurity.model.CategoryWithFindingNum(
        categoryName.map(value => value),
        findingNumber.map(value => value)
      )
    def categoryName: Optional[String]
    def findingNumber: Optional[Integer]
    def getCategoryName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("categoryName", categoryName)
    def getFindingNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("findingNumber", findingNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum
  ) extends zio.aws.codegurusecurity.model.CategoryWithFindingNum.ReadOnly {
    override val categoryName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.categoryName())
      .map(value => value: String)
    override val findingNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.findingNumber())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum
  ): zio.aws.codegurusecurity.model.CategoryWithFindingNum.ReadOnly =
    new Wrapper(impl)
}
