package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScanNameWithFindingNum(
    findingNumber: Optional[Integer] = Optional.Absent,
    scanName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum = {
    import ScanNameWithFindingNum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum
      .builder()
      .optionallyWith(findingNumber.map(value => value: java.lang.Integer))(
        _.findingNumber
      )
      .optionallyWith(scanName.map(value => value: java.lang.String))(
        _.scanName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.ScanNameWithFindingNum.ReadOnly =
    zio.aws.codegurusecurity.model.ScanNameWithFindingNum.wrap(buildAwsValue())
}
object ScanNameWithFindingNum {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.ScanNameWithFindingNum =
      zio.aws.codegurusecurity.model.ScanNameWithFindingNum(
        findingNumber.map(value => value),
        scanName.map(value => value)
      )
    def findingNumber: Optional[Integer]
    def scanName: Optional[String]
    def getFindingNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("findingNumber", findingNumber)
    def getScanName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scanName", scanName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum
  ) extends zio.aws.codegurusecurity.model.ScanNameWithFindingNum.ReadOnly {
    override val findingNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.findingNumber())
      .map(value => value: Integer)
    override val scanName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scanName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum
  ): zio.aws.codegurusecurity.model.ScanNameWithFindingNum.ReadOnly =
    new Wrapper(impl)
}
