package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateAccountConfigurationRequest(
    encryptionConfig: zio.aws.codegurusecurity.model.EncryptionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationRequest = {
    import UpdateAccountConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationRequest
      .builder()
      .encryptionConfig(encryptionConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.UpdateAccountConfigurationRequest.ReadOnly =
    zio.aws.codegurusecurity.model.UpdateAccountConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateAccountConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurusecurity.model.UpdateAccountConfigurationRequest =
      zio.aws.codegurusecurity.model
        .UpdateAccountConfigurationRequest(encryptionConfig.asEditable)
    def encryptionConfig
        : zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly
    def getEncryptionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly
    ] = ZIO.succeed(encryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationRequest
  ) extends zio.aws.codegurusecurity.model.UpdateAccountConfigurationRequest.ReadOnly {
    override val encryptionConfig
        : zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly =
      zio.aws.codegurusecurity.model.EncryptionConfig
        .wrap(impl.encryptionConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationRequest
  ): zio.aws.codegurusecurity.model.UpdateAccountConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
