package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Resource(
    id: Optional[String] = Optional.Absent,
    subResourceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.Resource
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(subResourceId.map(value => value: java.lang.String))(
        _.subResourceId
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.Resource.ReadOnly =
    zio.aws.codegurusecurity.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.Resource =
      zio.aws.codegurusecurity.model
        .Resource(id.map(value => value), subResourceId.map(value => value))
    def id: Optional[String]
    def subResourceId: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getSubResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subResourceId", subResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.Resource
  ) extends zio.aws.codegurusecurity.model.Resource.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val subResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subResourceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.Resource
  ): zio.aws.codegurusecurity.model.Resource.ReadOnly = new Wrapper(impl)
}
