package zio.aws.codegurusecurity.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codegurusecurity.model.primitives.{
  ScanNameArn,
  ScanName,
  Uuid,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class GetScanResponse(
    analysisType: zio.aws.codegurusecurity.model.AnalysisType,
    createdAt: Timestamp,
    numberOfRevisions: Optional[Long] = Optional.Absent,
    runId: Uuid,
    scanName: ScanName,
    scanNameArn: Optional[ScanNameArn] = Optional.Absent,
    scanState: zio.aws.codegurusecurity.model.ScanState,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.GetScanResponse = {
    import GetScanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.GetScanResponse
      .builder()
      .analysisType(analysisType.unwrap)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(numberOfRevisions.map(value => value: java.lang.Long))(
        _.numberOfRevisions
      )
      .runId(Uuid.unwrap(runId): java.lang.String)
      .scanName(ScanName.unwrap(scanName): java.lang.String)
      .optionallyWith(
        scanNameArn.map(value => ScanNameArn.unwrap(value): java.lang.String)
      )(_.scanNameArn)
      .scanState(scanState.unwrap)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.GetScanResponse.ReadOnly =
    zio.aws.codegurusecurity.model.GetScanResponse.wrap(buildAwsValue())
}
object GetScanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.GetScanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.GetScanResponse =
      zio.aws.codegurusecurity.model.GetScanResponse(
        analysisType,
        createdAt,
        numberOfRevisions.map(value => value),
        runId,
        scanName,
        scanNameArn.map(value => value),
        scanState,
        updatedAt.map(value => value)
      )
    def analysisType: zio.aws.codegurusecurity.model.AnalysisType
    def createdAt: Timestamp
    def numberOfRevisions: Optional[Long]
    def runId: Uuid
    def scanName: ScanName
    def scanNameArn: Optional[ScanNameArn]
    def scanState: zio.aws.codegurusecurity.model.ScanState
    def updatedAt: Optional[Timestamp]
    def getAnalysisType
        : ZIO[Any, Nothing, zio.aws.codegurusecurity.model.AnalysisType] =
      ZIO.succeed(analysisType)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getNumberOfRevisions: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("numberOfRevisions", numberOfRevisions)
    def getRunId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(runId)
    def getScanName: ZIO[Any, Nothing, ScanName] = ZIO.succeed(scanName)
    def getScanNameArn: ZIO[Any, AwsError, ScanNameArn] =
      AwsError.unwrapOptionField("scanNameArn", scanNameArn)
    def getScanState
        : ZIO[Any, Nothing, zio.aws.codegurusecurity.model.ScanState] =
      ZIO.succeed(scanState)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetScanResponse
  ) extends zio.aws.codegurusecurity.model.GetScanResponse.ReadOnly {
    override val analysisType: zio.aws.codegurusecurity.model.AnalysisType =
      zio.aws.codegurusecurity.model.AnalysisType.wrap(impl.analysisType())
    override val createdAt: Timestamp =
      zio.aws.codegurusecurity.model.primitives.Timestamp(impl.createdAt())
    override val numberOfRevisions: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfRevisions())
      .map(value => value: Long)
    override val runId: Uuid =
      zio.aws.codegurusecurity.model.primitives.Uuid(impl.runId())
    override val scanName: ScanName =
      zio.aws.codegurusecurity.model.primitives.ScanName(impl.scanName())
    override val scanNameArn: Optional[ScanNameArn] = zio.aws.core.internal
      .optionalFromNullable(impl.scanNameArn())
      .map(value =>
        zio.aws.codegurusecurity.model.primitives.ScanNameArn(value)
      )
    override val scanState: zio.aws.codegurusecurity.model.ScanState =
      zio.aws.codegurusecurity.model.ScanState.wrap(impl.scanState())
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.codegurusecurity.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetScanResponse
  ): zio.aws.codegurusecurity.model.GetScanResponse.ReadOnly = new Wrapper(impl)
}
