package zio.aws.codegurusecurity.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codegurusecurity.model.primitives.{
  ScanName,
  NextToken,
  GetFindingsRequestMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetFindingsRequest(
    maxResults: Optional[GetFindingsRequestMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    scanName: ScanName,
    status: Optional[zio.aws.codegurusecurity.model.Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest = {
    import GetFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          GetFindingsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .scanName(ScanName.unwrap(scanName): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.GetFindingsRequest.ReadOnly =
    zio.aws.codegurusecurity.model.GetFindingsRequest.wrap(buildAwsValue())
}
object GetFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.GetFindingsRequest =
      zio.aws.codegurusecurity.model.GetFindingsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        scanName,
        status.map(value => value)
      )
    def maxResults: Optional[GetFindingsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def scanName: ScanName
    def status: Optional[zio.aws.codegurusecurity.model.Status]
    def getMaxResults: ZIO[Any, AwsError, GetFindingsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScanName: ZIO[Any, Nothing, ScanName] = ZIO.succeed(scanName)
    def getStatus: ZIO[Any, AwsError, zio.aws.codegurusecurity.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest
  ) extends zio.aws.codegurusecurity.model.GetFindingsRequest.ReadOnly {
    override val maxResults: Optional[GetFindingsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codegurusecurity.model.primitives
            .GetFindingsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurusecurity.model.primitives.NextToken(value))
    override val scanName: ScanName =
      zio.aws.codegurusecurity.model.primitives.ScanName(impl.scanName())
    override val status: Optional[zio.aws.codegurusecurity.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codegurusecurity.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest
  ): zio.aws.codegurusecurity.model.GetFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
