package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAccountConfigurationResponse(
    encryptionConfig: zio.aws.codegurusecurity.model.EncryptionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationResponse = {
    import GetAccountConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationResponse
      .builder()
      .encryptionConfig(encryptionConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.GetAccountConfigurationResponse.ReadOnly =
    zio.aws.codegurusecurity.model.GetAccountConfigurationResponse
      .wrap(buildAwsValue())
}
object GetAccountConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurusecurity.model.GetAccountConfigurationResponse =
      zio.aws.codegurusecurity.model
        .GetAccountConfigurationResponse(encryptionConfig.asEditable)
    def encryptionConfig
        : zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly
    def getEncryptionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly
    ] = ZIO.succeed(encryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationResponse
  ) extends zio.aws.codegurusecurity.model.GetAccountConfigurationResponse.ReadOnly {
    override val encryptionConfig
        : zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly =
      zio.aws.codegurusecurity.model.EncryptionConfig
        .wrap(impl.encryptionConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationResponse
  ): zio.aws.codegurusecurity.model.GetAccountConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
