package zio.aws.codegurusecurity.model
import scala.jdk.CollectionConverters._
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.codegurusecurity.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.codegurusecurity.model.ErrorCode
  ): zio.aws.codegurusecurity.model.ErrorCode = value match {
    case software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.DUPLICATE_IDENTIFIER =>
      val r = DUPLICATE_IDENTIFIER
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.ITEM_DOES_NOT_EXIST =>
      val r = ITEM_DOES_NOT_EXIST
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.INVALID_FINDING_ID =>
      val r = INVALID_FINDING_ID
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.INVALID_SCAN_NAME =>
      val r = INVALID_SCAN_NAME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurusecurity.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ErrorCode =
      software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object DUPLICATE_IDENTIFIER
      extends zio.aws.codegurusecurity.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ErrorCode =
      software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.DUPLICATE_IDENTIFIER
  }
  case object ITEM_DOES_NOT_EXIST
      extends zio.aws.codegurusecurity.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ErrorCode =
      software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.ITEM_DOES_NOT_EXIST
  }
  case object INTERNAL_ERROR extends zio.aws.codegurusecurity.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ErrorCode =
      software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.INTERNAL_ERROR
  }
  case object INVALID_FINDING_ID
      extends zio.aws.codegurusecurity.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ErrorCode =
      software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.INVALID_FINDING_ID
  }
  case object INVALID_SCAN_NAME
      extends zio.aws.codegurusecurity.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ErrorCode =
      software.amazon.awssdk.services.codegurusecurity.model.ErrorCode.INVALID_SCAN_NAME
  }
}
