package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.{TagKey, ScanNameArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ScanNameArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.UntagResourceRequest
      .builder()
      .resourceArn(ScanNameArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.UntagResourceRequest.ReadOnly =
    zio.aws.codegurusecurity.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.UntagResourceRequest =
      zio.aws.codegurusecurity.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ScanNameArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ScanNameArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.UntagResourceRequest
  ) extends zio.aws.codegurusecurity.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ScanNameArn =
      zio.aws.codegurusecurity.model.primitives.ScanNameArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.codegurusecurity.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.UntagResourceRequest
  ): zio.aws.codegurusecurity.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
