package zio.aws.codegurusecurity.model
import scala.jdk.CollectionConverters._
sealed trait Severity {
  def unwrap: software.amazon.awssdk.services.codegurusecurity.model.Severity
}
object Severity {
  def wrap(
      value: software.amazon.awssdk.services.codegurusecurity.model.Severity
  ): zio.aws.codegurusecurity.model.Severity = value match {
    case software.amazon.awssdk.services.codegurusecurity.model.Severity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurusecurity.model.Severity.CRITICAL =>
      val r = Critical
      r
    case software.amazon.awssdk.services.codegurusecurity.model.Severity.HIGH =>
      val r = High
      r
    case software.amazon.awssdk.services.codegurusecurity.model.Severity.MEDIUM =>
      val r = Medium
      r
    case software.amazon.awssdk.services.codegurusecurity.model.Severity.LOW =>
      val r = Low
      r
    case software.amazon.awssdk.services.codegurusecurity.model.Severity.INFO =>
      val r = Info
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurusecurity.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Severity =
      software.amazon.awssdk.services.codegurusecurity.model.Severity.UNKNOWN_TO_SDK_VERSION
  }
  case object Critical extends zio.aws.codegurusecurity.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Severity =
      software.amazon.awssdk.services.codegurusecurity.model.Severity.CRITICAL
  }
  case object High extends zio.aws.codegurusecurity.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Severity =
      software.amazon.awssdk.services.codegurusecurity.model.Severity.HIGH
  }
  case object Medium extends zio.aws.codegurusecurity.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Severity =
      software.amazon.awssdk.services.codegurusecurity.model.Severity.MEDIUM
  }
  case object Low extends zio.aws.codegurusecurity.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Severity =
      software.amazon.awssdk.services.codegurusecurity.model.Severity.LOW
  }
  case object Info extends zio.aws.codegurusecurity.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Severity =
      software.amazon.awssdk.services.codegurusecurity.model.Severity.INFO
  }
}
