package zio.aws.codegurusecurity.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codegurusecurity.model.primitives.{
  ScanNameArn,
  ScanName,
  Uuid,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class ScanSummary(
    createdAt: Timestamp,
    runId: Uuid,
    scanName: ScanName,
    scanNameArn: Optional[ScanNameArn] = Optional.Absent,
    scanState: zio.aws.codegurusecurity.model.ScanState,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.ScanSummary = {
    import ScanSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.ScanSummary
      .builder()
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .runId(Uuid.unwrap(runId): java.lang.String)
      .scanName(ScanName.unwrap(scanName): java.lang.String)
      .optionallyWith(
        scanNameArn.map(value => ScanNameArn.unwrap(value): java.lang.String)
      )(_.scanNameArn)
      .scanState(scanState.unwrap)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.ScanSummary.ReadOnly =
    zio.aws.codegurusecurity.model.ScanSummary.wrap(buildAwsValue())
}
object ScanSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.ScanSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.ScanSummary =
      zio.aws.codegurusecurity.model.ScanSummary(
        createdAt,
        runId,
        scanName,
        scanNameArn.map(value => value),
        scanState,
        updatedAt.map(value => value)
      )
    def createdAt: Timestamp
    def runId: Uuid
    def scanName: ScanName
    def scanNameArn: Optional[ScanNameArn]
    def scanState: zio.aws.codegurusecurity.model.ScanState
    def updatedAt: Optional[Timestamp]
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getRunId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(runId)
    def getScanName: ZIO[Any, Nothing, ScanName] = ZIO.succeed(scanName)
    def getScanNameArn: ZIO[Any, AwsError, ScanNameArn] =
      AwsError.unwrapOptionField("scanNameArn", scanNameArn)
    def getScanState
        : ZIO[Any, Nothing, zio.aws.codegurusecurity.model.ScanState] =
      ZIO.succeed(scanState)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ScanSummary
  ) extends zio.aws.codegurusecurity.model.ScanSummary.ReadOnly {
    override val createdAt: Timestamp =
      zio.aws.codegurusecurity.model.primitives.Timestamp(impl.createdAt())
    override val runId: Uuid =
      zio.aws.codegurusecurity.model.primitives.Uuid(impl.runId())
    override val scanName: ScanName =
      zio.aws.codegurusecurity.model.primitives.ScanName(impl.scanName())
    override val scanNameArn: Optional[ScanNameArn] = zio.aws.core.internal
      .optionalFromNullable(impl.scanNameArn())
      .map(value =>
        zio.aws.codegurusecurity.model.primitives.ScanNameArn(value)
      )
    override val scanState: zio.aws.codegurusecurity.model.ScanState =
      zio.aws.codegurusecurity.model.ScanState.wrap(impl.scanState())
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.codegurusecurity.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ScanSummary
  ): zio.aws.codegurusecurity.model.ScanSummary.ReadOnly = new Wrapper(impl)
}
