package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListScansResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    summaries: Optional[Iterable[zio.aws.codegurusecurity.model.ScanSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse = {
    import ListScansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.ListScansResponse.ReadOnly =
    zio.aws.codegurusecurity.model.ListScansResponse.wrap(buildAwsValue())
}
object ListScansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.ListScansResponse =
      zio.aws.codegurusecurity.model.ListScansResponse(
        nextToken.map(value => value),
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def summaries
        : Optional[List[zio.aws.codegurusecurity.model.ScanSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.codegurusecurity.model.ScanSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse
  ) extends zio.aws.codegurusecurity.model.ListScansResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurusecurity.model.primitives.NextToken(value))
    override val summaries
        : Optional[List[zio.aws.codegurusecurity.model.ScanSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurusecurity.model.ScanSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse
  ): zio.aws.codegurusecurity.model.ListScansResponse.ReadOnly = new Wrapper(
    impl
  )
}
