package zio.aws.codegurusecurity.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codegurusecurity.model.primitives.{
  NextToken,
  ListFindingsMetricsRequestMaxResultsInteger,
  Timestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFindingsMetricsRequest(
    endDate: Timestamp,
    maxResults: Optional[ListFindingsMetricsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    startDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest = {
    import ListFindingsMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest
      .builder()
      .endDate(Timestamp.unwrap(endDate): Instant)
      .optionallyWith(
        maxResults.map(value =>
          ListFindingsMetricsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.ListFindingsMetricsRequest.ReadOnly =
    zio.aws.codegurusecurity.model.ListFindingsMetricsRequest
      .wrap(buildAwsValue())
}
object ListFindingsMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.ListFindingsMetricsRequest =
      zio.aws.codegurusecurity.model.ListFindingsMetricsRequest(
        endDate,
        maxResults.map(value => value),
        nextToken.map(value => value),
        startDate
      )
    def endDate: Timestamp
    def maxResults: Optional[ListFindingsMetricsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def startDate: Timestamp
    def getEndDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDate)
    def getMaxResults
        : ZIO[Any, AwsError, ListFindingsMetricsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest
  ) extends zio.aws.codegurusecurity.model.ListFindingsMetricsRequest.ReadOnly {
    override val endDate: Timestamp =
      zio.aws.codegurusecurity.model.primitives.Timestamp(impl.endDate())
    override val maxResults
        : Optional[ListFindingsMetricsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codegurusecurity.model.primitives
            .ListFindingsMetricsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurusecurity.model.primitives.NextToken(value))
    override val startDate: Timestamp =
      zio.aws.codegurusecurity.model.primitives.Timestamp(impl.startDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest
  ): zio.aws.codegurusecurity.model.ListFindingsMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
