package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CodeLine(
    content: Optional[String] = Optional.Absent,
    number: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.CodeLine = {
    import CodeLine.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.CodeLine
      .builder()
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(number.map(value => value: java.lang.Integer))(_.number)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.CodeLine.ReadOnly =
    zio.aws.codegurusecurity.model.CodeLine.wrap(buildAwsValue())
}
object CodeLine {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.CodeLine
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.CodeLine =
      zio.aws.codegurusecurity.model
        .CodeLine(content.map(value => value), number.map(value => value))
    def content: Optional[String]
    def number: Optional[Integer]
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("number", number)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CodeLine
  ) extends zio.aws.codegurusecurity.model.CodeLine.ReadOnly {
    override val content: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: String)
    override val number: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.number())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CodeLine
  ): zio.aws.codegurusecurity.model.CodeLine.ReadOnly = new Wrapper(impl)
}
