package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetFindingsResponse(
    failedFindings: Iterable[
      zio.aws.codegurusecurity.model.BatchGetFindingsError
    ],
    findings: Iterable[zio.aws.codegurusecurity.model.Finding]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsResponse = {
    import BatchGetFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsResponse
      .builder()
      .failedFindings(failedFindings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .findings(findings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.BatchGetFindingsResponse.ReadOnly =
    zio.aws.codegurusecurity.model.BatchGetFindingsResponse
      .wrap(buildAwsValue())
}
object BatchGetFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.BatchGetFindingsResponse =
      zio.aws.codegurusecurity.model.BatchGetFindingsResponse(
        failedFindings.map { item =>
          item.asEditable
        },
        findings.map { item =>
          item.asEditable
        }
      )
    def failedFindings
        : List[zio.aws.codegurusecurity.model.BatchGetFindingsError.ReadOnly]
    def findings: List[zio.aws.codegurusecurity.model.Finding.ReadOnly]
    def getFailedFindings: ZIO[Any, Nothing, List[
      zio.aws.codegurusecurity.model.BatchGetFindingsError.ReadOnly
    ]] = ZIO.succeed(failedFindings)
    def getFindings: ZIO[Any, Nothing, List[
      zio.aws.codegurusecurity.model.Finding.ReadOnly
    ]] = ZIO.succeed(findings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsResponse
  ) extends zio.aws.codegurusecurity.model.BatchGetFindingsResponse.ReadOnly {
    override val failedFindings
        : List[zio.aws.codegurusecurity.model.BatchGetFindingsError.ReadOnly] =
      impl
        .failedFindings()
        .asScala
        .map { item =>
          zio.aws.codegurusecurity.model.BatchGetFindingsError.wrap(item)
        }
        .toList
    override val findings
        : List[zio.aws.codegurusecurity.model.Finding.ReadOnly] = impl
      .findings()
      .asScala
      .map { item =>
        zio.aws.codegurusecurity.model.Finding.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsResponse
  ): zio.aws.codegurusecurity.model.BatchGetFindingsResponse.ReadOnly =
    new Wrapper(impl)
}
