package zio.aws.codegurusecurity.model
import scala.jdk.CollectionConverters._
sealed trait ScanType {
  def unwrap: software.amazon.awssdk.services.codegurusecurity.model.ScanType
}
object ScanType {
  def wrap(
      value: software.amazon.awssdk.services.codegurusecurity.model.ScanType
  ): zio.aws.codegurusecurity.model.ScanType = value match {
    case software.amazon.awssdk.services.codegurusecurity.model.ScanType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ScanType.STANDARD =>
      val r = Standard
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ScanType.EXPRESS =>
      val r = Express
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurusecurity.model.ScanType {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ScanType =
      software.amazon.awssdk.services.codegurusecurity.model.ScanType.UNKNOWN_TO_SDK_VERSION
  }
  case object Standard extends zio.aws.codegurusecurity.model.ScanType {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ScanType =
      software.amazon.awssdk.services.codegurusecurity.model.ScanType.STANDARD
  }
  case object Express extends zio.aws.codegurusecurity.model.ScanType {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ScanType =
      software.amazon.awssdk.services.codegurusecurity.model.ScanType.EXPRESS
  }
}
