package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceId(codeArtifactId: Optional[Uuid] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.ResourceId = {
    import ResourceId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.ResourceId
      .builder()
      .optionallyWith(
        codeArtifactId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.codeArtifactId)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.ResourceId.ReadOnly =
    zio.aws.codegurusecurity.model.ResourceId.wrap(buildAwsValue())
}
object ResourceId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.ResourceId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.ResourceId =
      zio.aws.codegurusecurity.model
        .ResourceId(codeArtifactId.map(value => value))
    def codeArtifactId: Optional[Uuid]
    def getCodeArtifactId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("codeArtifactId", codeArtifactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ResourceId
  ) extends zio.aws.codegurusecurity.model.ResourceId.ReadOnly {
    override val codeArtifactId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.codeArtifactId())
      .map(value => zio.aws.codegurusecurity.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ResourceId
  ): zio.aws.codegurusecurity.model.ResourceId.ReadOnly = new Wrapper(impl)
}
