package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.{ScanNameArn, ScanName, Uuid}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateScanResponse(
    resourceId: zio.aws.codegurusecurity.model.ResourceId,
    runId: Uuid,
    scanName: ScanName,
    scanNameArn: Optional[ScanNameArn] = Optional.Absent,
    scanState: zio.aws.codegurusecurity.model.ScanState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.CreateScanResponse = {
    import CreateScanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.CreateScanResponse
      .builder()
      .resourceId(resourceId.buildAwsValue())
      .runId(Uuid.unwrap(runId): java.lang.String)
      .scanName(ScanName.unwrap(scanName): java.lang.String)
      .optionallyWith(
        scanNameArn.map(value => ScanNameArn.unwrap(value): java.lang.String)
      )(_.scanNameArn)
      .scanState(scanState.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.CreateScanResponse.ReadOnly =
    zio.aws.codegurusecurity.model.CreateScanResponse.wrap(buildAwsValue())
}
object CreateScanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.CreateScanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.CreateScanResponse =
      zio.aws.codegurusecurity.model.CreateScanResponse(
        resourceId.asEditable,
        runId,
        scanName,
        scanNameArn.map(value => value),
        scanState
      )
    def resourceId: zio.aws.codegurusecurity.model.ResourceId.ReadOnly
    def runId: Uuid
    def scanName: ScanName
    def scanNameArn: Optional[ScanNameArn]
    def scanState: zio.aws.codegurusecurity.model.ScanState
    def getResourceId: ZIO[
      Any,
      Nothing,
      zio.aws.codegurusecurity.model.ResourceId.ReadOnly
    ] = ZIO.succeed(resourceId)
    def getRunId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(runId)
    def getScanName: ZIO[Any, Nothing, ScanName] = ZIO.succeed(scanName)
    def getScanNameArn: ZIO[Any, AwsError, ScanNameArn] =
      AwsError.unwrapOptionField("scanNameArn", scanNameArn)
    def getScanState
        : ZIO[Any, Nothing, zio.aws.codegurusecurity.model.ScanState] =
      ZIO.succeed(scanState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CreateScanResponse
  ) extends zio.aws.codegurusecurity.model.CreateScanResponse.ReadOnly {
    override val resourceId
        : zio.aws.codegurusecurity.model.ResourceId.ReadOnly =
      zio.aws.codegurusecurity.model.ResourceId.wrap(impl.resourceId())
    override val runId: Uuid =
      zio.aws.codegurusecurity.model.primitives.Uuid(impl.runId())
    override val scanName: ScanName =
      zio.aws.codegurusecurity.model.primitives.ScanName(impl.scanName())
    override val scanNameArn: Optional[ScanNameArn] = zio.aws.core.internal
      .optionalFromNullable(impl.scanNameArn())
      .map(value =>
        zio.aws.codegurusecurity.model.primitives.ScanNameArn(value)
      )
    override val scanState: zio.aws.codegurusecurity.model.ScanState =
      zio.aws.codegurusecurity.model.ScanState.wrap(impl.scanState())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CreateScanResponse
  ): zio.aws.codegurusecurity.model.CreateScanResponse.ReadOnly = new Wrapper(
    impl
  )
}
