package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetFindingsRequest(
    findingIdentifiers: Iterable[
      zio.aws.codegurusecurity.model.FindingIdentifier
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsRequest = {
    import BatchGetFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsRequest
      .builder()
      .findingIdentifiers(findingIdentifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.BatchGetFindingsRequest.ReadOnly =
    zio.aws.codegurusecurity.model.BatchGetFindingsRequest.wrap(buildAwsValue())
}
object BatchGetFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.BatchGetFindingsRequest =
      zio.aws.codegurusecurity.model
        .BatchGetFindingsRequest(findingIdentifiers.map { item =>
          item.asEditable
        })
    def findingIdentifiers
        : List[zio.aws.codegurusecurity.model.FindingIdentifier.ReadOnly]
    def getFindingIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.codegurusecurity.model.FindingIdentifier.ReadOnly
    ]] = ZIO.succeed(findingIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsRequest
  ) extends zio.aws.codegurusecurity.model.BatchGetFindingsRequest.ReadOnly {
    override val findingIdentifiers
        : List[zio.aws.codegurusecurity.model.FindingIdentifier.ReadOnly] = impl
      .findingIdentifiers()
      .asScala
      .map { item =>
        zio.aws.codegurusecurity.model.FindingIdentifier.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsRequest
  ): zio.aws.codegurusecurity.model.BatchGetFindingsRequest.ReadOnly =
    new Wrapper(impl)
}
