package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateAccountConfigurationResponse(
    encryptionConfig: zio.aws.codegurusecurity.model.EncryptionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationResponse = {
    import UpdateAccountConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationResponse
      .builder()
      .encryptionConfig(encryptionConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse.ReadOnly =
    zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateAccountConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse =
      zio.aws.codegurusecurity.model
        .UpdateAccountConfigurationResponse(encryptionConfig.asEditable)
    def encryptionConfig
        : zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly
    def getEncryptionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly
    ] = ZIO.succeed(encryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationResponse
  ) extends zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse.ReadOnly {
    override val encryptionConfig
        : zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly =
      zio.aws.codegurusecurity.model.EncryptionConfig
        .wrap(impl.encryptionConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationResponse
  ): zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
