package zio.aws.codegurusecurity.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codegurusecurity.model.primitives.{
  NextToken,
  ListScansRequestMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListScansRequest(
    maxResults: Optional[ListScansRequestMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest = {
    import ListScansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListScansRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.ListScansRequest.ReadOnly =
    zio.aws.codegurusecurity.model.ListScansRequest.wrap(buildAwsValue())
}
object ListScansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.ListScansRequest =
      zio.aws.codegurusecurity.model.ListScansRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListScansRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, ListScansRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest
  ) extends zio.aws.codegurusecurity.model.ListScansRequest.ReadOnly {
    override val maxResults: Optional[ListScansRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codegurusecurity.model.primitives
            .ListScansRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurusecurity.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest
  ): zio.aws.codegurusecurity.model.ListScansRequest.ReadOnly = new Wrapper(
    impl
  )
}
