package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.{
  S3Url,
  HeaderValue,
  HeaderKey,
  Uuid
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateUploadUrlResponse(
    codeArtifactId: Uuid,
    requestHeaders: Map[HeaderKey, HeaderValue],
    s3Url: S3Url
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlResponse = {
    import CreateUploadUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlResponse
      .builder()
      .codeArtifactId(Uuid.unwrap(codeArtifactId): java.lang.String)
      .requestHeaders(
        requestHeaders
          .map({ case (key, value) =>
            (HeaderKey.unwrap(key): java.lang.String) -> (HeaderValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .s3Url(S3Url.unwrap(s3Url): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.CreateUploadUrlResponse.ReadOnly =
    zio.aws.codegurusecurity.model.CreateUploadUrlResponse.wrap(buildAwsValue())
}
object CreateUploadUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.CreateUploadUrlResponse =
      zio.aws.codegurusecurity.model
        .CreateUploadUrlResponse(codeArtifactId, requestHeaders, s3Url)
    def codeArtifactId: Uuid
    def requestHeaders: Map[HeaderKey, HeaderValue]
    def s3Url: S3Url
    def getCodeArtifactId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(codeArtifactId)
    def getRequestHeaders: ZIO[Any, Nothing, Map[HeaderKey, HeaderValue]] =
      ZIO.succeed(requestHeaders)
    def getS3Url: ZIO[Any, Nothing, S3Url] = ZIO.succeed(s3Url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlResponse
  ) extends zio.aws.codegurusecurity.model.CreateUploadUrlResponse.ReadOnly {
    override val codeArtifactId: Uuid =
      zio.aws.codegurusecurity.model.primitives.Uuid(impl.codeArtifactId())
    override val requestHeaders: Map[HeaderKey, HeaderValue] = impl
      .requestHeaders()
      .asScala
      .map({ case (key, value) =>
        zio.aws.codegurusecurity.model.primitives.HeaderKey(
          key
        ) -> zio.aws.codegurusecurity.model.primitives.HeaderValue(value)
      })
      .toMap
    override val s3Url: S3Url =
      zio.aws.codegurusecurity.model.primitives.S3Url(impl.s3Url())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlResponse
  ): zio.aws.codegurusecurity.model.CreateUploadUrlResponse.ReadOnly =
    new Wrapper(impl)
}
