package zio.aws.codegurusecurity.model
import scala.jdk.CollectionConverters._
sealed trait AnalysisType {
  def unwrap
      : software.amazon.awssdk.services.codegurusecurity.model.AnalysisType
}
object AnalysisType {
  def wrap(
      value: software.amazon.awssdk.services.codegurusecurity.model.AnalysisType
  ): zio.aws.codegurusecurity.model.AnalysisType = value match {
    case software.amazon.awssdk.services.codegurusecurity.model.AnalysisType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurusecurity.model.AnalysisType.SECURITY =>
      val r = Security
      r
    case software.amazon.awssdk.services.codegurusecurity.model.AnalysisType.ALL =>
      val r = All
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurusecurity.model.AnalysisType {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.AnalysisType =
      software.amazon.awssdk.services.codegurusecurity.model.AnalysisType.UNKNOWN_TO_SDK_VERSION
  }
  case object Security extends zio.aws.codegurusecurity.model.AnalysisType {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.AnalysisType =
      software.amazon.awssdk.services.codegurusecurity.model.AnalysisType.SECURITY
  }
  case object All extends zio.aws.codegurusecurity.model.AnalysisType {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.AnalysisType =
      software.amazon.awssdk.services.codegurusecurity.model.AnalysisType.ALL
  }
}
