package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.ScanNameArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ScanNameArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ScanNameArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.codegurusecurity.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.ListTagsForResourceRequest =
      zio.aws.codegurusecurity.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ScanNameArn
    def getResourceArn: ZIO[Any, Nothing, ScanNameArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceRequest
  ) extends zio.aws.codegurusecurity.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ScanNameArn =
      zio.aws.codegurusecurity.model.primitives.ScanNameArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceRequest
  ): zio.aws.codegurusecurity.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
