package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.KmsKeyArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EncryptionConfig(
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.EncryptionConfig = {
    import EncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.EncryptionConfig
      .builder()
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly =
    zio.aws.codegurusecurity.model.EncryptionConfig.wrap(buildAwsValue())
}
object EncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.EncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.EncryptionConfig =
      zio.aws.codegurusecurity.model
        .EncryptionConfig(kmsKeyArn.map(value => value))
    def kmsKeyArn: Optional[KmsKeyArn]
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.EncryptionConfig
  ) extends zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly {
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.codegurusecurity.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.EncryptionConfig
  ): zio.aws.codegurusecurity.model.EncryptionConfig.ReadOnly = new Wrapper(
    impl
  )
}
