package zio.aws.codegurureviewer.model
import zio.aws.codegurureviewer.model.primitives.{
  Text,
  LineNumber,
  RecommendationId,
  FilePath
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RecommendationSummary(
    filePath: Optional[FilePath] = Optional.Absent,
    recommendationId: Optional[RecommendationId] = Optional.Absent,
    startLine: Optional[LineNumber] = Optional.Absent,
    endLine: Optional[LineNumber] = Optional.Absent,
    description: Optional[Text] = Optional.Absent,
    recommendationCategory: Optional[
      zio.aws.codegurureviewer.model.RecommendationCategory
    ] = Optional.Absent,
    ruleMetadata: Optional[zio.aws.codegurureviewer.model.RuleMetadata] =
      Optional.Absent,
    severity: Optional[zio.aws.codegurureviewer.model.Severity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RecommendationSummary = {
    import RecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RecommendationSummary
      .builder()
      .optionallyWith(
        filePath.map(value => FilePath.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(
        recommendationId.map(value =>
          RecommendationId.unwrap(value): java.lang.String
        )
      )(_.recommendationId)
      .optionallyWith(
        startLine.map(value => LineNumber.unwrap(value): Integer)
      )(_.startLine)
      .optionallyWith(endLine.map(value => LineNumber.unwrap(value): Integer))(
        _.endLine
      )
      .optionallyWith(
        description.map(value => Text.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(recommendationCategory.map(value => value.unwrap))(
        _.recommendationCategory
      )
      .optionallyWith(ruleMetadata.map(value => value.buildAwsValue()))(
        _.ruleMetadata
      )
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly =
    zio.aws.codegurureviewer.model.RecommendationSummary.wrap(buildAwsValue())
}
object RecommendationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RecommendationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.RecommendationSummary =
      zio.aws.codegurureviewer.model.RecommendationSummary(
        filePath.map(value => value),
        recommendationId.map(value => value),
        startLine.map(value => value),
        endLine.map(value => value),
        description.map(value => value),
        recommendationCategory.map(value => value),
        ruleMetadata.map(value => value.asEditable),
        severity.map(value => value)
      )
    def filePath: Optional[FilePath]
    def recommendationId: Optional[RecommendationId]
    def startLine: Optional[LineNumber]
    def endLine: Optional[LineNumber]
    def description: Optional[Text]
    def recommendationCategory
        : Optional[zio.aws.codegurureviewer.model.RecommendationCategory]
    def ruleMetadata
        : Optional[zio.aws.codegurureviewer.model.RuleMetadata.ReadOnly]
    def severity: Optional[zio.aws.codegurureviewer.model.Severity]
    def getFilePath: ZIO[Any, AwsError, FilePath] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getRecommendationId: ZIO[Any, AwsError, RecommendationId] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
    def getStartLine: ZIO[Any, AwsError, LineNumber] =
      AwsError.unwrapOptionField("startLine", startLine)
    def getEndLine: ZIO[Any, AwsError, LineNumber] =
      AwsError.unwrapOptionField("endLine", endLine)
    def getDescription: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("description", description)
    def getRecommendationCategory: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RecommendationCategory
    ] = AwsError.unwrapOptionField(
      "recommendationCategory",
      recommendationCategory
    )
    def getRuleMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RuleMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("ruleMetadata", ruleMetadata)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.Severity] =
      AwsError.unwrapOptionField("severity", severity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RecommendationSummary
  ) extends zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly {
    override val filePath: Optional[FilePath] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value => zio.aws.codegurureviewer.model.primitives.FilePath(value))
    override val recommendationId: Optional[RecommendationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationId())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.RecommendationId(value)
        )
    override val startLine: Optional[LineNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.startLine())
      .map(value => zio.aws.codegurureviewer.model.primitives.LineNumber(value))
    override val endLine: Optional[LineNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.endLine())
      .map(value => zio.aws.codegurureviewer.model.primitives.LineNumber(value))
    override val description: Optional[Text] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codegurureviewer.model.primitives.Text(value))
    override val recommendationCategory
        : Optional[zio.aws.codegurureviewer.model.RecommendationCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationCategory())
        .map(value =>
          zio.aws.codegurureviewer.model.RecommendationCategory.wrap(value)
        )
    override val ruleMetadata
        : Optional[zio.aws.codegurureviewer.model.RuleMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleMetadata())
        .map(value => zio.aws.codegurureviewer.model.RuleMetadata.wrap(value))
    override val severity: Optional[zio.aws.codegurureviewer.model.Severity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.codegurureviewer.model.Severity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RecommendationSummary
  ): zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly =
    new Wrapper(impl)
}
