package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codegurureviewer.model.primitives.S3BucketName
import scala.jdk.CollectionConverters.*
final case class S3RepositoryDetails(
    bucketName: Optional[S3BucketName] = Optional.Absent,
    codeArtifacts: Optional[zio.aws.codegurureviewer.model.CodeArtifacts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails = {
    import S3RepositoryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails
      .builder()
      .optionallyWith(
        bucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.bucketName)
      .optionallyWith(codeArtifacts.map(value => value.buildAwsValue()))(
        _.codeArtifacts
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly =
    zio.aws.codegurureviewer.model.S3RepositoryDetails.wrap(buildAwsValue())
}
object S3RepositoryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.S3RepositoryDetails =
      zio.aws.codegurureviewer.model.S3RepositoryDetails(
        bucketName.map(value => value),
        codeArtifacts.map(value => value.asEditable)
      )
    def bucketName: Optional[S3BucketName]
    def codeArtifacts
        : Optional[zio.aws.codegurureviewer.model.CodeArtifacts.ReadOnly]
    def getBucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getCodeArtifacts: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.CodeArtifacts.ReadOnly
    ] = AwsError.unwrapOptionField("codeArtifacts", codeArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails
  ) extends zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly {
    override val bucketName: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.S3BucketName(value)
      )
    override val codeArtifacts
        : Optional[zio.aws.codegurureviewer.model.CodeArtifacts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeArtifacts())
        .map(value => zio.aws.codegurureviewer.model.CodeArtifacts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails
  ): zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly = new Wrapper(
    impl
  )
}
