package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codegurureviewer.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class DescribeRepositoryAssociationResponse(
    repositoryAssociation: Optional[
      zio.aws.codegurureviewer.model.RepositoryAssociation
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationResponse = {
    import DescribeRepositoryAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationResponse
      .builder()
      .optionallyWith(
        repositoryAssociation.map(value => value.buildAwsValue())
      )(_.repositoryAssociation)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse.ReadOnly =
    zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse
      .wrap(buildAwsValue())
}
object DescribeRepositoryAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse =
      zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse(
        repositoryAssociation.map(value => value.asEditable),
        tags.map(value => value)
      )
    def repositoryAssociation: Optional[
      zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly
    ]
    def tags: Optional[Map[TagKey, TagValue]]
    def getRepositoryAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly
    ] =
      AwsError.unwrapOptionField("repositoryAssociation", repositoryAssociation)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationResponse
  ) extends zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse.ReadOnly {
    override val repositoryAssociation: Optional[
      zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryAssociation())
      .map(value =>
        zio.aws.codegurureviewer.model.RepositoryAssociation.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codegurureviewer.model.primitives.TagKey(
              key
            ) -> zio.aws.codegurureviewer.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationResponse
  ): zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
