package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionOption {
  def unwrap
      : software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption
}
object EncryptionOption {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption
  ): zio.aws.codegurureviewer.model.EncryptionOption = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption.AWS_OWNED_CMK =>
      val r = AWS_OWNED_CMK
      r
    case software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption.CUSTOMER_MANAGED_CMK =>
      val r = CUSTOMER_MANAGED_CMK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption =
      software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_OWNED_CMK
      extends zio.aws.codegurureviewer.model.EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption =
      software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption.AWS_OWNED_CMK
  }
  case object CUSTOMER_MANAGED_CMK
      extends zio.aws.codegurureviewer.model.EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption =
      software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption.CUSTOMER_MANAGED_CMK
  }
}
