package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters.*
sealed trait RepositoryAssociationState {
  def unwrap: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState
}
object RepositoryAssociationState {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState
  ): zio.aws.codegurureviewer.model.RepositoryAssociationState = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.ASSOCIATED =>
      val r = Associated
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.ASSOCIATING =>
      val r = Associating
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.DISASSOCIATING =>
      val r = Disassociating
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.DISASSOCIATED =>
      val r = Disassociated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.RepositoryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState =
      software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object Associated
      extends zio.aws.codegurureviewer.model.RepositoryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState =
      software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.ASSOCIATED
  }
  case object Associating
      extends zio.aws.codegurureviewer.model.RepositoryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState =
      software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.ASSOCIATING
  }
  case object Failed
      extends zio.aws.codegurureviewer.model.RepositoryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState =
      software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.FAILED
  }
  case object Disassociating
      extends zio.aws.codegurureviewer.model.RepositoryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState =
      software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.DISASSOCIATING
  }
  case object Disassociated
      extends zio.aws.codegurureviewer.model.RepositoryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState =
      software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState.DISASSOCIATED
  }
}
