package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Repository(
    codeCommit: Optional[zio.aws.codegurureviewer.model.CodeCommitRepository] =
      Optional.Absent,
    bitbucket: Optional[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository
    ] = Optional.Absent,
    gitHubEnterpriseServer: Optional[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository
    ] = Optional.Absent,
    s3Bucket: Optional[zio.aws.codegurureviewer.model.S3Repository] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.Repository = {
    import Repository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.Repository
      .builder()
      .optionallyWith(codeCommit.map(value => value.buildAwsValue()))(
        _.codeCommit
      )
      .optionallyWith(bitbucket.map(value => value.buildAwsValue()))(
        _.bitbucket
      )
      .optionallyWith(
        gitHubEnterpriseServer.map(value => value.buildAwsValue())
      )(_.gitHubEnterpriseServer)
      .optionallyWith(s3Bucket.map(value => value.buildAwsValue()))(_.s3Bucket)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.Repository.ReadOnly =
    zio.aws.codegurureviewer.model.Repository.wrap(buildAwsValue())
}
object Repository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.Repository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.Repository =
      zio.aws.codegurureviewer.model.Repository(
        codeCommit.map(value => value.asEditable),
        bitbucket.map(value => value.asEditable),
        gitHubEnterpriseServer.map(value => value.asEditable),
        s3Bucket.map(value => value.asEditable)
      )
    def codeCommit
        : Optional[zio.aws.codegurureviewer.model.CodeCommitRepository.ReadOnly]
    def bitbucket: Optional[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ]
    def gitHubEnterpriseServer: Optional[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ]
    def s3Bucket: Optional[zio.aws.codegurureviewer.model.S3Repository.ReadOnly]
    def getCodeCommit: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.CodeCommitRepository.ReadOnly
    ] = AwsError.unwrapOptionField("codeCommit", codeCommit)
    def getBitbucket: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ] = AwsError.unwrapOptionField("bitbucket", bitbucket)
    def getGitHubEnterpriseServer: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ] = AwsError.unwrapOptionField(
      "gitHubEnterpriseServer",
      gitHubEnterpriseServer
    )
    def getS3Bucket: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.S3Repository.ReadOnly
    ] = AwsError.unwrapOptionField("s3Bucket", s3Bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.Repository
  ) extends zio.aws.codegurureviewer.model.Repository.ReadOnly {
    override val codeCommit: Optional[
      zio.aws.codegurureviewer.model.CodeCommitRepository.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.codeCommit())
      .map(value =>
        zio.aws.codegurureviewer.model.CodeCommitRepository.wrap(value)
      )
    override val bitbucket: Optional[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bitbucket())
      .map(value =>
        zio.aws.codegurureviewer.model.ThirdPartySourceRepository.wrap(value)
      )
    override val gitHubEnterpriseServer: Optional[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gitHubEnterpriseServer())
      .map(value =>
        zio.aws.codegurureviewer.model.ThirdPartySourceRepository.wrap(value)
      )
    override val s3Bucket
        : Optional[zio.aws.codegurureviewer.model.S3Repository.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Bucket())
        .map(value => zio.aws.codegurureviewer.model.S3Repository.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.Repository
  ): zio.aws.codegurureviewer.model.Repository.ReadOnly = new Wrapper(impl)
}
