package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codegurureviewer.model.primitives.{UserId, RecommendationId, Arn}
import scala.jdk.CollectionConverters.*
final case class DescribeRecommendationFeedbackRequest(
    codeReviewArn: Arn,
    recommendationId: RecommendationId,
    userId: Optional[UserId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest = {
    import DescribeRecommendationFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest
      .builder()
      .codeReviewArn(Arn.unwrap(codeReviewArn): java.lang.String)
      .recommendationId(
        RecommendationId.unwrap(recommendationId): java.lang.String
      )
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackRequest.ReadOnly =
    zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackRequest
      .wrap(buildAwsValue())
}
object DescribeRecommendationFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackRequest =
      zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackRequest(
        codeReviewArn,
        recommendationId,
        userId.map(value => value)
      )
    def codeReviewArn: Arn
    def recommendationId: RecommendationId
    def userId: Optional[UserId]
    def getCodeReviewArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(codeReviewArn)
    def getRecommendationId: ZIO[Any, Nothing, RecommendationId] =
      ZIO.succeed(recommendationId)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest
  ) extends zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackRequest.ReadOnly {
    override val codeReviewArn: Arn =
      zio.aws.codegurureviewer.model.primitives.Arn(impl.codeReviewArn())
    override val recommendationId: RecommendationId =
      zio.aws.codegurureviewer.model.primitives
        .RecommendationId(impl.recommendationId())
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.codegurureviewer.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest
  ): zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackRequest.ReadOnly =
    new Wrapper(impl)
}
