package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters.*
sealed trait ConfigFileState {
  def unwrap
      : software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState
}
object ConfigFileState {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState
  ): zio.aws.codegurureviewer.model.ConfigFileState = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState.PRESENT =>
      val r = Present
      r
    case software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState.ABSENT =>
      val r = Absent
      r
    case software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState.PRESENT_WITH_ERRORS =>
      val r = PresentWithErrors
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.ConfigFileState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState =
      software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState.UNKNOWN_TO_SDK_VERSION
  }
  case object Present extends zio.aws.codegurureviewer.model.ConfigFileState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState =
      software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState.PRESENT
  }
  case object Absent extends zio.aws.codegurureviewer.model.ConfigFileState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState =
      software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState.ABSENT
  }
  case object PresentWithErrors
      extends zio.aws.codegurureviewer.model.ConfigFileState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState =
      software.amazon.awssdk.services.codegurureviewer.model.ConfigFileState.PRESENT_WITH_ERRORS
  }
}
