package zio.aws.codegurureviewer
import zio.aws.codegurureviewer.model.ListCodeReviewsResponse.ReadOnly
import zio.aws.codegurureviewer.model.{
  ListCodeReviewsRequest,
  AssociateRepositoryRequest,
  ListRecommendationsRequest,
  ListTagsForResourceRequest,
  DescribeCodeReviewRequest,
  CreateCodeReviewRequest,
  PutRecommendationFeedbackRequest,
  DisassociateRepositoryRequest,
  UntagResourceRequest,
  DescribeRepositoryAssociationRequest,
  ListRecommendationFeedbackRequest,
  ListRepositoryAssociationsRequest,
  DescribeRecommendationFeedbackRequest,
  TagResourceRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.codegurureviewer.{
  CodeGuruReviewerAsyncClientBuilder,
  CodeGuruReviewerAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.codegurureviewer.model.{
  CodeReviewSummary,
  CreateCodeReviewResponse,
  RecommendationSummary,
  DescribeCodeReviewResponse,
  DisassociateRepositoryResponse,
  ListTagsForResourceResponse,
  RepositoryAssociationSummary,
  UntagResourceResponse,
  ListCodeReviewsResponse,
  RecommendationFeedbackSummary,
  AssociateRepositoryResponse,
  ListRecommendationFeedbackResponse,
  DescribeRecommendationFeedbackResponse,
  ListRepositoryAssociationsResponse,
  PutRecommendationFeedbackResponse,
  DescribeRepositoryAssociationResponse,
  TagResourceResponse,
  ListRecommendationsResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait CodeGuruReviewer extends AspectSupport[CodeGuruReviewer] {
  val api: CodeGuruReviewerAsyncClient
  def listRecommendations(request: ListRecommendationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly
  ]
  def listRecommendationsPaginated(request: ListRecommendationsRequest): IO[
    AwsError,
    zio.aws.codegurureviewer.model.ListRecommendationsResponse.ReadOnly
  ]
  def createCodeReview(request: CreateCodeReviewRequest): IO[
    AwsError,
    zio.aws.codegurureviewer.model.CreateCodeReviewResponse.ReadOnly
  ]
  def associateRepository(request: AssociateRepositoryRequest): IO[
    AwsError,
    zio.aws.codegurureviewer.model.AssociateRepositoryResponse.ReadOnly
  ]
  def disassociateRepository(request: DisassociateRepositoryRequest): IO[
    AwsError,
    zio.aws.codegurureviewer.model.DisassociateRepositoryResponse.ReadOnly
  ]
  def describeCodeReview(request: DescribeCodeReviewRequest): IO[
    AwsError,
    zio.aws.codegurureviewer.model.DescribeCodeReviewResponse.ReadOnly
  ]
  def listRepositoryAssociations(
      request: ListRepositoryAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly
  ]
  def listRepositoryAssociationsPaginated(
      request: ListRepositoryAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse.ReadOnly
  ]
  def listCodeReviews(request: ListCodeReviewsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly
  ]
  def listCodeReviewsPaginated(
      request: ListCodeReviewsRequest
  ): IO[AwsError, ReadOnly]
  def describeRepositoryAssociation(
      request: DescribeRepositoryAssociationRequest
  ): IO[
    AwsError,
    zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.codegurureviewer.model.UntagResourceResponse.ReadOnly]
  def listRecommendationFeedback(
      request: ListRecommendationFeedbackRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly
  ]
  def listRecommendationFeedbackPaginated(
      request: ListRecommendationFeedbackRequest
  ): IO[
    AwsError,
    zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.codegurureviewer.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.codegurureviewer.model.TagResourceResponse.ReadOnly]
  def putRecommendationFeedback(request: PutRecommendationFeedbackRequest): IO[
    AwsError,
    zio.aws.codegurureviewer.model.PutRecommendationFeedbackResponse.ReadOnly
  ]
  def describeRecommendationFeedback(
      request: DescribeRecommendationFeedbackRequest
  ): IO[
    AwsError,
    zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse.ReadOnly
  ]
}
object CodeGuruReviewer {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodeGuruReviewer] =
    customized(identity)
  def customized(
      customization: CodeGuruReviewerAsyncClientBuilder => CodeGuruReviewerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodeGuruReviewer] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CodeGuruReviewerAsyncClientBuilder => CodeGuruReviewerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CodeGuruReviewer] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = CodeGuruReviewerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      CodeGuruReviewerAsyncClient,
      CodeGuruReviewerAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      CodeGuruReviewerAsyncClient,
      CodeGuruReviewerAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new CodeGuruReviewerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CodeGuruReviewerImpl[R](
      override val api: CodeGuruReviewerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodeGuruReviewer
      with AwsServiceBase[R] {
    override val serviceName: String = "CodeGuruReviewer"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeGuruReviewerImpl[R1] = new CodeGuruReviewerImpl(api, newAspect, r)
    def listRecommendations(request: ListRecommendationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest,
      ListRecommendationsResponse,
      RecommendationSummary
    ](
      "listRecommendations",
      api.listRecommendations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.recommendationSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codegurureviewer.model.RecommendationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listRecommendationsPaginated(request: ListRecommendationsRequest): IO[
      AwsError,
      zio.aws.codegurureviewer.model.ListRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest,
      ListRecommendationsResponse
    ]("listRecommendations", api.listRecommendations)(request.buildAwsValue())
      .map(zio.aws.codegurureviewer.model.ListRecommendationsResponse.wrap)
      .provideEnvironment(r)
    def createCodeReview(request: CreateCodeReviewRequest): IO[
      AwsError,
      zio.aws.codegurureviewer.model.CreateCodeReviewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewRequest,
      CreateCodeReviewResponse
    ]("createCodeReview", api.createCodeReview)(request.buildAwsValue())
      .map(zio.aws.codegurureviewer.model.CreateCodeReviewResponse.wrap)
      .provideEnvironment(r)
    def associateRepository(request: AssociateRepositoryRequest): IO[
      AwsError,
      zio.aws.codegurureviewer.model.AssociateRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.AssociateRepositoryRequest,
      AssociateRepositoryResponse
    ]("associateRepository", api.associateRepository)(request.buildAwsValue())
      .map(zio.aws.codegurureviewer.model.AssociateRepositoryResponse.wrap)
      .provideEnvironment(r)
    def disassociateRepository(request: DisassociateRepositoryRequest): IO[
      AwsError,
      zio.aws.codegurureviewer.model.DisassociateRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryRequest,
      DisassociateRepositoryResponse
    ]("disassociateRepository", api.disassociateRepository)(
      request.buildAwsValue()
    ).map(zio.aws.codegurureviewer.model.DisassociateRepositoryResponse.wrap)
      .provideEnvironment(r)
    def describeCodeReview(request: DescribeCodeReviewRequest): IO[
      AwsError,
      zio.aws.codegurureviewer.model.DescribeCodeReviewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewRequest,
      DescribeCodeReviewResponse
    ]("describeCodeReview", api.describeCodeReview)(request.buildAwsValue())
      .map(zio.aws.codegurureviewer.model.DescribeCodeReviewResponse.wrap)
      .provideEnvironment(r)
    def listRepositoryAssociations(
        request: ListRepositoryAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest,
      ListRepositoryAssociationsResponse,
      RepositoryAssociationSummary
    ](
      "listRepositoryAssociations",
      api.listRepositoryAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.repositoryAssociationSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codegurureviewer.model.RepositoryAssociationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listRepositoryAssociationsPaginated(
        request: ListRepositoryAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest,
      ListRepositoryAssociationsResponse
    ]("listRepositoryAssociations", api.listRepositoryAssociations)(
      request.buildAwsValue()
    ).map(
      zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse.wrap
    ).provideEnvironment(r)
    def listCodeReviews(request: ListCodeReviewsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest,
      ListCodeReviewsResponse,
      CodeReviewSummary
    ](
      "listCodeReviews",
      api.listCodeReviews,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.codeReviewSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.codegurureviewer.model.CodeReviewSummary.wrap(item))
      .provideEnvironment(r)
    def listCodeReviewsPaginated(
        request: ListCodeReviewsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest,
      ListCodeReviewsResponse
    ]("listCodeReviews", api.listCodeReviews)(request.buildAwsValue())
      .map(zio.aws.codegurureviewer.model.ListCodeReviewsResponse.wrap)
      .provideEnvironment(r)
    def describeRepositoryAssociation(
        request: DescribeRepositoryAssociationRequest
    ): IO[
      AwsError,
      zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationRequest,
      DescribeRepositoryAssociationResponse
    ]("describeRepositoryAssociation", api.describeRepositoryAssociation)(
      request.buildAwsValue()
    ).map(
      zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse.wrap
    ).provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.codegurureviewer.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.codegurureviewer.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listRecommendationFeedback(
        request: ListRecommendationFeedbackRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest,
      ListRecommendationFeedbackResponse,
      RecommendationFeedbackSummary
    ](
      "listRecommendationFeedback",
      api.listRecommendationFeedback,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.recommendationFeedbackSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listRecommendationFeedbackPaginated(
        request: ListRecommendationFeedbackRequest
    ): IO[
      AwsError,
      zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest,
      ListRecommendationFeedbackResponse
    ]("listRecommendationFeedback", api.listRecommendationFeedback)(
      request.buildAwsValue()
    ).map(
      zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse.wrap
    ).provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.codegurureviewer.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.codegurureviewer.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.codegurureviewer.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.codegurureviewer.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def putRecommendationFeedback(
        request: PutRecommendationFeedbackRequest
    ): IO[
      AwsError,
      zio.aws.codegurureviewer.model.PutRecommendationFeedbackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.PutRecommendationFeedbackRequest,
      PutRecommendationFeedbackResponse
    ]("putRecommendationFeedback", api.putRecommendationFeedback)(
      request.buildAwsValue()
    ).map(zio.aws.codegurureviewer.model.PutRecommendationFeedbackResponse.wrap)
      .provideEnvironment(r)
    def describeRecommendationFeedback(
        request: DescribeRecommendationFeedbackRequest
    ): IO[
      AwsError,
      zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest,
      DescribeRecommendationFeedbackResponse
    ]("describeRecommendationFeedback", api.describeRecommendationFeedback)(
      request.buildAwsValue()
    ).map(
      zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse.wrap
    ).provideEnvironment(r)
  }
  def listRecommendations(request: ListRecommendationsRequest): ZStream[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecommendations(request))
  def listRecommendationsPaginated(request: ListRecommendationsRequest): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.ListRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecommendationsPaginated(request))
  def createCodeReview(request: CreateCodeReviewRequest): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.CreateCodeReviewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCodeReview(request))
  def associateRepository(request: AssociateRepositoryRequest): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.AssociateRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateRepository(request))
  def disassociateRepository(request: DisassociateRepositoryRequest): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.DisassociateRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateRepository(request))
  def describeCodeReview(request: DescribeCodeReviewRequest): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.DescribeCodeReviewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCodeReview(request))
  def listRepositoryAssociations(
      request: ListRepositoryAssociationsRequest
  ): ZStream[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRepositoryAssociations(request))
  def listRepositoryAssociationsPaginated(
      request: ListRepositoryAssociationsRequest
  ): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRepositoryAssociationsPaginated(request))
  def listCodeReviews(request: ListCodeReviewsRequest): ZStream[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCodeReviews(request))
  def listCodeReviewsPaginated(
      request: ListCodeReviewsRequest
  ): ZIO[zio.aws.codegurureviewer.CodeGuruReviewer, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listCodeReviewsPaginated(request))
  def describeRepositoryAssociation(
      request: DescribeRepositoryAssociationRequest
  ): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRepositoryAssociation(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listRecommendationFeedback(
      request: ListRecommendationFeedbackRequest
  ): ZStream[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecommendationFeedback(request))
  def listRecommendationFeedbackPaginated(
      request: ListRecommendationFeedbackRequest
  ): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecommendationFeedbackPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def putRecommendationFeedback(request: PutRecommendationFeedbackRequest): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.PutRecommendationFeedbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRecommendationFeedback(request))
  def describeRecommendationFeedback(
      request: DescribeRecommendationFeedbackRequest
  ): ZIO[
    zio.aws.codegurureviewer.CodeGuruReviewer,
    AwsError,
    zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRecommendationFeedback(request))
}
