package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCodeReviewResponse(
    codeReview: Optional[zio.aws.codegurureviewer.model.CodeReview] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewResponse = {
    import CreateCodeReviewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewResponse
      .builder()
      .optionallyWith(codeReview.map(value => value.buildAwsValue()))(
        _.codeReview
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.CreateCodeReviewResponse.ReadOnly =
    zio.aws.codegurureviewer.model.CreateCodeReviewResponse
      .wrap(buildAwsValue())
}
object CreateCodeReviewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CreateCodeReviewResponse =
      zio.aws.codegurureviewer.model
        .CreateCodeReviewResponse(codeReview.map(value => value.asEditable))
    def codeReview: Optional[zio.aws.codegurureviewer.model.CodeReview.ReadOnly]
    def getCodeReview: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.CodeReview.ReadOnly
    ] = AwsError.unwrapOptionField("codeReview", codeReview)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewResponse
  ) extends zio.aws.codegurureviewer.model.CreateCodeReviewResponse.ReadOnly {
    override val codeReview
        : Optional[zio.aws.codegurureviewer.model.CodeReview.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeReview())
        .map(value => zio.aws.codegurureviewer.model.CodeReview.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewResponse
  ): zio.aws.codegurureviewer.model.CreateCodeReviewResponse.ReadOnly =
    new Wrapper(impl)
}
