package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters.*
sealed trait VendorName {
  def unwrap: software.amazon.awssdk.services.codegurureviewer.model.VendorName
}
object VendorName {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.VendorName
  ): zio.aws.codegurureviewer.model.VendorName = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.VendorName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.VendorName.GIT_HUB =>
      val r = GitHub
      r
    case software.amazon.awssdk.services.codegurureviewer.model.VendorName.GIT_LAB =>
      val r = GitLab
      r
    case software.amazon.awssdk.services.codegurureviewer.model.VendorName.NATIVE_S3 =>
      val r = NativeS3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.VendorName {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.VendorName =
      software.amazon.awssdk.services.codegurureviewer.model.VendorName.UNKNOWN_TO_SDK_VERSION
  }
  case object GitHub extends zio.aws.codegurureviewer.model.VendorName {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.VendorName =
      software.amazon.awssdk.services.codegurureviewer.model.VendorName.GIT_HUB
  }
  case object GitLab extends zio.aws.codegurureviewer.model.VendorName {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.VendorName =
      software.amazon.awssdk.services.codegurureviewer.model.VendorName.GIT_LAB
  }
  case object NativeS3 extends zio.aws.codegurureviewer.model.VendorName {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.VendorName =
      software.amazon.awssdk.services.codegurureviewer.model.VendorName.NATIVE_S3
  }
}
