package zio.aws.codegurureviewer.model
import zio.aws.codegurureviewer.model.primitives.{
  AssociationId,
  Owner,
  Arn,
  ConnectionArn,
  TimeStamp,
  Name
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class RepositoryAssociationSummary(
    associationArn: Optional[Arn] = Optional.Absent,
    connectionArn: Optional[ConnectionArn] = Optional.Absent,
    lastUpdatedTimeStamp: Optional[TimeStamp] = Optional.Absent,
    associationId: Optional[AssociationId] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    owner: Optional[Owner] = Optional.Absent,
    providerType: Optional[zio.aws.codegurureviewer.model.ProviderType] =
      Optional.Absent,
    state: Optional[zio.aws.codegurureviewer.model.RepositoryAssociationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary = {
    import RepositoryAssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary
      .builder()
      .optionallyWith(
        associationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.associationArn)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(
        lastUpdatedTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdatedTimeStamp)
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        owner.map(value => Owner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly =
    zio.aws.codegurureviewer.model.RepositoryAssociationSummary
      .wrap(buildAwsValue())
}
object RepositoryAssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.RepositoryAssociationSummary =
      zio.aws.codegurureviewer.model.RepositoryAssociationSummary(
        associationArn.map(value => value),
        connectionArn.map(value => value),
        lastUpdatedTimeStamp.map(value => value),
        associationId.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        providerType.map(value => value),
        state.map(value => value)
      )
    def associationArn: Optional[Arn]
    def connectionArn: Optional[ConnectionArn]
    def lastUpdatedTimeStamp: Optional[TimeStamp]
    def associationId: Optional[AssociationId]
    def name: Optional[Name]
    def owner: Optional[Owner]
    def providerType: Optional[zio.aws.codegurureviewer.model.ProviderType]
    def state
        : Optional[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    def getAssociationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("associationArn", associationArn)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getLastUpdatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdatedTimeStamp", lastUpdatedTimeStamp)
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryAssociationState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary
  ) extends zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly {
    override val associationArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.associationArn())
      .map(value => zio.aws.codegurureviewer.model.primitives.Arn(value))
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.ConnectionArn(value)
      )
    override val lastUpdatedTimeStamp: Optional[TimeStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimeStamp())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.TimeStamp(value)
        )
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.AssociationId(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val owner: Optional[Owner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.codegurureviewer.model.primitives.Owner(value))
    override val providerType
        : Optional[zio.aws.codegurureviewer.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerType())
        .map(value => zio.aws.codegurureviewer.model.ProviderType.wrap(value))
    override val state
        : Optional[zio.aws.codegurureviewer.model.RepositoryAssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.codegurureviewer.model.RepositoryAssociationState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary
  ): zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly =
    new Wrapper(impl)
}
