package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceCodeType(
    commitDiff: Optional[
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType
    ] = Optional.Absent,
    repositoryHead: Optional[
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType
    ] = Optional.Absent,
    branchDiff: Optional[
      zio.aws.codegurureviewer.model.BranchDiffSourceCodeType
    ] = Optional.Absent,
    s3BucketRepository: Optional[
      zio.aws.codegurureviewer.model.S3BucketRepository
    ] = Optional.Absent,
    requestMetadata: Optional[zio.aws.codegurureviewer.model.RequestMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType = {
    import SourceCodeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType
      .builder()
      .optionallyWith(commitDiff.map(value => value.buildAwsValue()))(
        _.commitDiff
      )
      .optionallyWith(repositoryHead.map(value => value.buildAwsValue()))(
        _.repositoryHead
      )
      .optionallyWith(branchDiff.map(value => value.buildAwsValue()))(
        _.branchDiff
      )
      .optionallyWith(s3BucketRepository.map(value => value.buildAwsValue()))(
        _.s3BucketRepository
      )
      .optionallyWith(requestMetadata.map(value => value.buildAwsValue()))(
        _.requestMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly =
    zio.aws.codegurureviewer.model.SourceCodeType.wrap(buildAwsValue())
}
object SourceCodeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.SourceCodeType =
      zio.aws.codegurureviewer.model.SourceCodeType(
        commitDiff.map(value => value.asEditable),
        repositoryHead.map(value => value.asEditable),
        branchDiff.map(value => value.asEditable),
        s3BucketRepository.map(value => value.asEditable),
        requestMetadata.map(value => value.asEditable)
      )
    def commitDiff: Optional[
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly
    ]
    def repositoryHead: Optional[
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly
    ]
    def branchDiff: Optional[
      zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.ReadOnly
    ]
    def s3BucketRepository
        : Optional[zio.aws.codegurureviewer.model.S3BucketRepository.ReadOnly]
    def requestMetadata
        : Optional[zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly]
    def getCommitDiff: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("commitDiff", commitDiff)
    def getRepositoryHead: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("repositoryHead", repositoryHead)
    def getBranchDiff: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("branchDiff", branchDiff)
    def getS3BucketRepository: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.S3BucketRepository.ReadOnly
    ] = AwsError.unwrapOptionField("s3BucketRepository", s3BucketRepository)
    def getRequestMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("requestMetadata", requestMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType
  ) extends zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly {
    override val commitDiff: Optional[
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commitDiff())
      .map(value =>
        zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.wrap(value)
      )
    override val repositoryHead: Optional[
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryHead())
      .map(value =>
        zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.wrap(value)
      )
    override val branchDiff: Optional[
      zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.branchDiff())
      .map(value =>
        zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.wrap(value)
      )
    override val s3BucketRepository
        : Optional[zio.aws.codegurureviewer.model.S3BucketRepository.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BucketRepository())
        .map(value =>
          zio.aws.codegurureviewer.model.S3BucketRepository.wrap(value)
        )
    override val requestMetadata
        : Optional[zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestMetadata())
        .map(value =>
          zio.aws.codegurureviewer.model.RequestMetadata.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType
  ): zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly = new Wrapper(impl)
}
