package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.AssociationArn
import scala.jdk.CollectionConverters.*
final case class DescribeRepositoryAssociationRequest(
    associationArn: AssociationArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationRequest = {
    import DescribeRepositoryAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationRequest
      .builder()
      .associationArn(AssociationArn.unwrap(associationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.DescribeRepositoryAssociationRequest.ReadOnly =
    zio.aws.codegurureviewer.model.DescribeRepositoryAssociationRequest
      .wrap(buildAwsValue())
}
object DescribeRepositoryAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.DescribeRepositoryAssociationRequest =
      zio.aws.codegurureviewer.model
        .DescribeRepositoryAssociationRequest(associationArn)
    def associationArn: AssociationArn
    def getAssociationArn: ZIO[Any, Nothing, AssociationArn] =
      ZIO.succeed(associationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationRequest
  ) extends zio.aws.codegurureviewer.model.DescribeRepositoryAssociationRequest.ReadOnly {
    override val associationArn: AssociationArn =
      zio.aws.codegurureviewer.model.primitives
        .AssociationArn(impl.associationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationRequest
  ): zio.aws.codegurureviewer.model.DescribeRepositoryAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
