package zio.aws.codegurureviewer
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.codegurureviewer.model.primitives.{
  RuleTag,
  Owner,
  UserId,
  TagValue,
  RecommendationId,
  Name,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.codegurureviewer.model.primitives.Arn.Type
    object AssociationArn extends Subtype[String]
    type AssociationArn =
      zio.aws.codegurureviewer.model.primitives.AssociationArn.Type
    object AssociationId extends Subtype[String]
    type AssociationId =
      zio.aws.codegurureviewer.model.primitives.AssociationId.Type
    object BranchName extends Subtype[String]
    type BranchName = zio.aws.codegurureviewer.model.primitives.BranchName.Type
    object BuildArtifactsObjectKey extends Subtype[String]
    type BuildArtifactsObjectKey =
      zio.aws.codegurureviewer.model.primitives.BuildArtifactsObjectKey.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.codegurureviewer.model.primitives.ClientRequestToken.Type
    object CodeReviewName extends Subtype[String]
    type CodeReviewName =
      zio.aws.codegurureviewer.model.primitives.CodeReviewName.Type
    object CommitId extends Subtype[String]
    type CommitId = zio.aws.codegurureviewer.model.primitives.CommitId.Type
    object ConnectionArn extends Subtype[String]
    type ConnectionArn =
      zio.aws.codegurureviewer.model.primitives.ConnectionArn.Type
    object EventName extends Subtype[String]
    type EventName = zio.aws.codegurureviewer.model.primitives.EventName.Type
    object EventState extends Subtype[String]
    type EventState = zio.aws.codegurureviewer.model.primitives.EventState.Type
    object FilePath extends Subtype[String]
    type FilePath = zio.aws.codegurureviewer.model.primitives.FilePath.Type
    object FindingsCount extends Subtype[Long]
    type FindingsCount =
      zio.aws.codegurureviewer.model.primitives.FindingsCount.Type
    object KMSKeyId extends Subtype[String]
    type KMSKeyId = zio.aws.codegurureviewer.model.primitives.KMSKeyId.Type
    object LineNumber extends Subtype[Int]
    type LineNumber = zio.aws.codegurureviewer.model.primitives.LineNumber.Type
    object LinesOfCodeCount extends Subtype[Long]
    type LinesOfCodeCount =
      zio.aws.codegurureviewer.model.primitives.LinesOfCodeCount.Type
    object ListCodeReviewsMaxResults extends Subtype[Int]
    type ListCodeReviewsMaxResults =
      zio.aws.codegurureviewer.model.primitives.ListCodeReviewsMaxResults.Type
    object ListRecommendationsMaxResults extends Subtype[Int]
    type ListRecommendationsMaxResults =
      zio.aws.codegurureviewer.model.primitives.ListRecommendationsMaxResults.Type
    object LongDescription extends Subtype[String]
    type LongDescription =
      zio.aws.codegurureviewer.model.primitives.LongDescription.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.codegurureviewer.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.codegurureviewer.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.codegurureviewer.model.primitives.NextToken.Type
    object Owner extends Subtype[String]
    type Owner = zio.aws.codegurureviewer.model.primitives.Owner.Type
    object PullRequestId extends Subtype[String]
    type PullRequestId =
      zio.aws.codegurureviewer.model.primitives.PullRequestId.Type
    object RecommendationId extends Subtype[String]
    type RecommendationId =
      zio.aws.codegurureviewer.model.primitives.RecommendationId.Type
    object RequestId extends Subtype[String]
    type RequestId = zio.aws.codegurureviewer.model.primitives.RequestId.Type
    object Requester extends Subtype[String]
    type Requester = zio.aws.codegurureviewer.model.primitives.Requester.Type
    object RuleId extends Subtype[String]
    type RuleId = zio.aws.codegurureviewer.model.primitives.RuleId.Type
    object RuleName extends Subtype[String]
    type RuleName = zio.aws.codegurureviewer.model.primitives.RuleName.Type
    object RuleTag extends Subtype[String]
    type RuleTag = zio.aws.codegurureviewer.model.primitives.RuleTag.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName =
      zio.aws.codegurureviewer.model.primitives.S3BucketName.Type
    object ShortDescription extends Subtype[String]
    type ShortDescription =
      zio.aws.codegurureviewer.model.primitives.ShortDescription.Type
    object SourceCodeArtifactsObjectKey extends Subtype[String]
    type SourceCodeArtifactsObjectKey =
      zio.aws.codegurureviewer.model.primitives.SourceCodeArtifactsObjectKey.Type
    object StateReason extends Subtype[String]
    type StateReason =
      zio.aws.codegurureviewer.model.primitives.StateReason.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.codegurureviewer.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.codegurureviewer.model.primitives.TagValue.Type
    object Text extends Subtype[String]
    type Text = zio.aws.codegurureviewer.model.primitives.Text.Type
    object TimeStamp extends Subtype[Instant]
    type TimeStamp = zio.aws.codegurureviewer.model.primitives.TimeStamp.Type
    object UserId extends Subtype[String]
    type UserId = zio.aws.codegurureviewer.model.primitives.UserId.Type
  }
  type AnalysisTypes = List[zio.aws.codegurureviewer.model.AnalysisType]
  type CodeReviewSummaries =
    List[zio.aws.codegurureviewer.model.CodeReviewSummary]
  type JobStates = List[zio.aws.codegurureviewer.model.JobState]
  type Names = List[Name]
  type Owners = List[Owner]
  type ProviderTypes = List[zio.aws.codegurureviewer.model.ProviderType]
  type Reactions = List[zio.aws.codegurureviewer.model.Reaction]
  type RecommendationFeedbackSummaries =
    List[zio.aws.codegurureviewer.model.RecommendationFeedbackSummary]
  type RecommendationIds = List[RecommendationId]
  type RecommendationSummaries =
    List[zio.aws.codegurureviewer.model.RecommendationSummary]
  type RepositoryAssociationStates =
    List[zio.aws.codegurureviewer.model.RepositoryAssociationState]
  type RepositoryAssociationSummaries =
    List[zio.aws.codegurureviewer.model.RepositoryAssociationSummary]
  type RepositoryNames = List[Name]
  type RuleTags = List[RuleTag]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type UserIds = List[UserId]
}
