package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.AssociationArn
import scala.jdk.CollectionConverters.*
final case class DisassociateRepositoryRequest(associationArn: AssociationArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryRequest = {
    import DisassociateRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryRequest
      .builder()
      .associationArn(AssociationArn.unwrap(associationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.DisassociateRepositoryRequest.ReadOnly =
    zio.aws.codegurureviewer.model.DisassociateRepositoryRequest
      .wrap(buildAwsValue())
}
object DisassociateRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.DisassociateRepositoryRequest =
      zio.aws.codegurureviewer.model
        .DisassociateRepositoryRequest(associationArn)
    def associationArn: AssociationArn
    def getAssociationArn: ZIO[Any, Nothing, AssociationArn] =
      ZIO.succeed(associationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryRequest
  ) extends zio.aws.codegurureviewer.model.DisassociateRepositoryRequest.ReadOnly {
    override val associationArn: AssociationArn =
      zio.aws.codegurureviewer.model.primitives
        .AssociationArn(impl.associationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryRequest
  ): zio.aws.codegurureviewer.model.DisassociateRepositoryRequest.ReadOnly =
    new Wrapper(impl)
}
